<?php

$db = new PDO('sqllite:/usr/local/data/sales/db');

$query = $db->query('SELECT region, start, end, amount FROM sales', PDO::FETCH_NUM);
$sales_data = $db->fetchAll();
$total = 0;
$column_headers = array('Region','Data pocztkowa','Data kocowa','Warto');
//Wyznaczenie formatu prezentowanych danych
$format = $_GET['format'] == 'csv' ? 'csv' : 'html';

//Wygenerowanie pierwszych wierszy zalenie od wybranego formatu
if ($format == 'csv') {
  $output = fopen('php://output','w') or die("Nie mona otworzy strumienia php://output");
  header('Content-Type: application/csv');
  header('Content-Disposition: attachment; filename="sprzedaz.csv"');
  fputcsv($output,$column_headers);
} else {
  echo '<table><tr><th>';
  echo implode('</th><th>', $column_headers);
  echo '</th></tr>';
}

foreach ($sales_data as $sales_line) {
  //Wygenerowanie wiersza waciwego dla danego formatu
  if ($format == 'csv') {
    fputcsv($output, $sales_line);
  } else {
    echo '<tr><td>' . implode('</td><td>', $sales_line) . '</td></tr>';
  }
  $total += $sales_line[3];
}
$total_line = array('Wszystkie regiony','--','--',$total);

//Wygenerowanie podsumowania waciwego dla danego formatu
if ($format == 'csv') {
  fputcsv($output,$total_line);
  fclose($output) or die("Nie mona zamkn strumienia php://output");
} else {
  echo '<tr><td>'. implode('</td><td>', $total_line) . '</td></tr>';
  echo '</table>';
}
?>
